<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LessonSection extends Model 
{

    protected $table = 'lessons_section';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'video', 'paragraph', 'lessons_section_number');

    public function lesson()
    {
        return $this->belongsTo('Lesson');
    }

}